<?php
if (!defined('ABSPATH')) exit;

// Adiciona a página de configurações no menu do WordPress
add_action('admin_menu', function() {
    add_menu_page('Calendário Limber', 'Calendário Limber', 'manage_options', 'limber-calendario', 'limber_settings_page_html', 'dashicons-calendar-alt', 20);
});

// Registra as configurações
add_action('admin_init', function() {
    register_setting('limber_settings_group', 'limber_settings');

    // Seção de API
    add_settings_section('limber_api_section', 'Credenciais e Parâmetros da API', null, 'limber-calendario');
    $api_fields = ['limber_usuario' => 'Usuário da API', 'limber_senha' => 'Senha da API', 'limber_sku' => 'SKU', 'limber_id_parceiro' => 'ID Parceiro', 'limber_receita' => 'ID Receita', 'url_ingresso' => 'URL Base Compra'];
    foreach ($api_fields as $id => $title) {
        add_settings_field($id, $title, 'limber_render_field', 'limber-calendario', 'limber_api_section', ['id' => $id]);
    }

    // Seção de Cores
    add_settings_section('limber_color_section', 'Personalização de Cores', null, 'limber-calendario');
    $color_fields = ['cor_principal' => 'Cor Principal', 'cor_precos' => 'Cor dos Preços'];
    foreach ($color_fields as $id => $title) {
        add_settings_field($id, $title, 'limber_render_field', 'limber-calendario', 'limber_color_section', ['id' => $id, 'type' => 'color']);
    }
});

// Renderiza os campos do formulário
function limber_render_field($args) {
    $options = get_option('limber_settings');
    $id = $args['id'];
    $value = $options[$id] ?? '';
    $type = $args['type'] ?? (($id === 'limber_senha') ? 'password' : 'text');
    if ($type === 'color' && empty($value)) $value = ($id === 'cor_principal') ? '#0099ff' : '#4caf50';
    $placeholder = ($id === 'url_ingresso') ? 'https://exemplo.com.br/?data=' : '';
    echo "<input type='$type' name='limber_settings[$id]' value='" . esc_attr($value) . "' " . ($type !== 'color' ? "class='regular-text'" : "") . " placeholder='$placeholder' " . (($id === 'limber_senha') ? 'autocomplete="new-password"' : '') . ">";
    if ($id === 'url_ingresso') echo "<p class='description'>URL para o checkout, incluindo <code>?data=</code> no final.</p>";
}

// Renderiza o HTML da página de admin
function limber_settings_page_html() {
    if (isset($_GET['action']) && $_GET['action'] == 'sync_now' && check_admin_referer('limber_sync_now')) {
        limber_sync_precos();
        echo '<div class="notice notice-success is-dismissible"><p>Sincronização manual concluída!</p></div>';
    }

    $last_sync_time = get_option('limber_last_sync_time');
    $last_sync_status = get_option('limber_last_sync_status');
    ?>
    <div class="wrap">
        <h1>Configurações do Calendário Limber</h1>

        <div style="background: #fff; border-left: 4px solid #46b450; padding: 10px 20px; margin-top: 20px;">
            <h3>Status da Sincronização</h3>
            <p>
                <strong>Última Sincronização:</strong>
                <?php echo $last_sync_time ? date_i18n('d/m/Y H:i:s', $last_sync_time) : 'Nunca'; ?>
            </p>
            <p>
                <strong>Resultado:</strong>
                <?php echo $last_sync_status ? esc_html($last_sync_status) : 'Aguardando primeira sincronização.'; ?>
            </p>
            <p>
                <a href="<?php echo wp_nonce_url(admin_url('admin.php?page=limber-calendario&action=sync_now'), 'limber_sync_now'); ?>" class="button button-secondary">Sincronizar Agora</a>
                <span class="description">A sincronização automática ocorre uma vez por dia. Use este botão para forçar uma atualização imediata.</span>
            </p>
        </div>

        <form action="options.php" method="post" style="margin-top: 20px;">
            <?php
            settings_fields('limber_settings_group');
            do_settings_sections('limber-calendario');
            submit_button('Salvar Alterações');
            ?>
        </form>
    </div>
    <?php
}