document.addEventListener('DOMContentLoaded', function () {
    const wrapper = document.getElementById('calendario-container-wrapper');
    const container = document.getElementById('calendar-days');
    const monthElement = document.getElementById('current-month');
    
    if (!wrapper || !container || !monthElement) {
        console.error('Um ou mais elementos essenciais do calendário não foram encontrados no HTML.');
        return;
    }

    const precosDosDias = calendarioConfig.precos || {};
    const urlBaseIngresso = calendarioConfig.urlIngresso || '';
    const hoje = new Date();
    hoje.setHours(0, 0, 0, 0); 
    let dataAtual = new Date(hoje.getFullYear(), hoje.getMonth(), 1);

    function renderizarCalendario() {
        const mes = dataAtual.getMonth();
        const ano = dataAtual.getFullYear();
        container.innerHTML = '';
        
        monthElement.textContent = new Date(ano, mes).toLocaleString('pt-BR', { month: 'long', year: 'numeric' });

        const primeiroDiaDoMes = new Date(ano, mes, 1).getDay();
        for (let i = 0; i < primeiroDiaDoMes; i++) {
            const emptyEl = document.createElement('div');
            emptyEl.className = 'calendario-dia empty';
            container.appendChild(emptyEl);
        }

        const diasNoMes = new Date(ano, mes + 1, 0).getDate();
        const DIA_FECHADO = 3; // Quarta-feira

        for (let i = 1; i <= diasNoMes; i++) {
            const dataCorrente = new Date(ano, mes, i);
            const dataString = dataCorrente.toISOString().split('T')[0];
            const isPassado = dataCorrente < hoje;
            const isDiaFechado = dataCorrente.getDay() === DIA_FECHADO;
            const precoDoDia = precosDosDias[dataString];
            
            const diaEl = document.createElement('a');
            diaEl.className = 'calendario-dia';

            if (isPassado || isDiaFechado || !precoDoDia) {
                diaEl.classList.add('desabilitado');
                diaEl.innerHTML = `<span class="dia-numero">${i}</span>`; // Não mostra preço
                if (isDiaFechado) {
                    diaEl.classList.add('fechado');
                }
            } else {
                diaEl.classList.add('disponivel');
                diaEl.href = `${urlBaseIngresso}${dataString}`;
                diaEl.setAttribute('target', '_blank');
                // ===== ALTERAÇÃO AQUI: O preço é inserido no HTML =====
                diaEl.innerHTML = `<span class="dia-numero">${i}</span><span class="dia-preco">R$${precoDoDia}</span>`;
            }

            container.appendChild(diaEl);
        }
    }

    document.getElementById('prev-month').addEventListener('click', () => {
        dataAtual.setMonth(dataAtual.getMonth() - 1);
        renderizarCalendario();
    });
    document.getElementById('next-month').addEventListener('click', () => {
        dataAtual.setMonth(dataAtual.getMonth() + 1);
        renderizarCalendario();
    });

    renderizarCalendario();
});